/*
 * Vuln Title: XXXX
 *
 * Copyright (C) 2005-2010 Sourcefire, Inc. All Rights Reserved
 *
 * Written by XXXX, Sourcefire VRT <XXXX@sourcefire.com>
 *
 * Auto-generated by XXXX
 *
 * This file may contain proprietary rules that were created, tested and
 * certified by Sourcefire, Inc. (the "VRT Certified Rules") as well as
 * rules that were created by Sourcefire and other third parties and
 * distributed under the GNU General Public License (the "GPL Rules").  The
 * VRT Certified Rules contained in this file are the property of
 * Sourcefire, Inc. Copyright 2005 Sourcefire, Inc. All Rights Reserved.
 * The GPL Rules created by Sourcefire, Inc. are the property of
 * Sourcefire, Inc. Copyright 2002-2005 Sourcefire, Inc. All Rights
 * Reserved.  All other GPL Rules are owned and copyrighted by their
 * respective owners (please see www.snort.org/contributors for a list of
 * owners and their respective copyrights).  In order to determine what
 * rules are VRT Certified Rules or GPL Rules, please refer to the VRT
 * Certified Rules License Agreement.
 */

#include "sf_snort_plugin_api.h"
#include "sf_snort_packet.h"

#include "so-util.h"

//#define DEBUG
//#ifdef DEBUG
//#define DEBUG_SO(code) code
//#else
//#define DEBUG_SO(code)
//#endif

/* declare detection functions */
int rule24666eval(void *p);

/* declare rule data structures */
/* flow:established, to_client; */
static FlowFlags rule24666flow0 = 
{
   FLOW_ESTABLISHED|FLOW_TO_CLIENT
};

static RuleOption rule24666option0 =
{
   OPTION_TYPE_FLOWFLAGS,
   {
      &rule24666flow0
   }
};
/* flowbits:isset "file.xls"; */
static FlowBitsInfo rule24666flowbits1 =
{
   "file.xls",
   FLOWBIT_ISSET,
   0
};

static RuleOption rule24666option1 =
{
   OPTION_TYPE_FLOWBIT,
   {
      &rule24666flowbits1
   }
};
// content:"x|08|", depth 0; 
static ContentInfo rule24666content2 = 
{
   (uint8_t *) "x|08|", /* pattern (now in snort content format) */
   0, /* depth */
   0, /* offset */
   CONTENT_BUF_NORMALIZED|CONTENT_RELATIVE, /* flags */
   NULL, /* holder for boyer/moore PTR */
   NULL, /* more holder info - byteform */
   0, /* byteform length */
   0 /* increment length*/
};

static RuleOption rule24666option2 = 
{
   OPTION_TYPE_CONTENT,
   {
      &rule24666content2
   }
};

/* references for sid 24666 */
/* reference: cve "2012-2543"; */
static RuleReference rule24666ref1 = 
{
   "cve", /* type */
   "2012-2543" /* value */
};

/* reference: url "technet.microsoft.com/security/bulletin/MS12-076"; */
static RuleReference rule24666ref2 = 
{
   "url", /* type */
   "technet.microsoft.com/security/bulletin/MS12-076" /* value */
};

static RuleReference *rule24666refs[] =
{
   &rule24666ref1,
   &rule24666ref2,
   NULL
};
/* metadata for sid 24666 */
/* metadata:service http, service imap, service pop3, policy security-ips drop; */
static RuleMetaData rule24666service1 = 
{
   "service http"
};

static RuleMetaData rule24666service2 = 
{
   "service imap"
};

static RuleMetaData rule24666service3 = 
{
   "service pop3"
};


static RuleMetaData rule24666policy1 = 
{
   "policy security-ips drop"
};


static RuleMetaData *rule24666metadata[] =
{
   &rule24666service1,
   &rule24666service2,
   &rule24666service3,
   &rule24666policy1,
   NULL
};

RuleOption *rule24666options[] =
{
   &rule24666option0,
   &rule24666option1,
   &rule24666option2,
   NULL
};

Rule rule24666 = {
   /* rule header, akin to => tcp any any -> any any */
   {
      IPPROTO_TCP, /* proto */
      "$EXTERNAL_NET", /* SRCIP    */
      "$FILE_DATA_PORTS", /* SRCPORT   */
      0, /* DIRECTION */
      "$HOME_NET", /* DSTIP    */
      "any", /* DSTPORT   */
   },
   /* metadata */
   { 
      3,  /* genid */
      24666, /* sigid */
      3, /* revision */
      "attempted-user", /* classification */
      0,  /* hardcoded priority XXX NOT PROVIDED BY GRAMMAR YET! */
      "FILE-OFFICE Excel invalid data item buffer overflow attempt",    /* message */
      rule24666refs /* ptr to references */
      ,rule24666metadata
   },
   rule24666options, /* ptr to rule options */
   &rule24666eval, /* use the built in detection function */
   0 /* am I initialized yet? */
};


/* detection functions */
// #if 0 // Don't compile the detection functions if they're not used
int rule24666eval(void *p) {
   const uint8_t *cursor_normal = 0;
   const uint8_t *beg_of_payload = 0;
   const uint8_t *end_of_payload = 0;
   const uint8_t *cursor_detect = 0;
   const uint8_t *cursor_tmp = 0;

   uint16_t cref = 0; // number of 8 byte refs
   uint16_t rgbNameL = 0; // length of rgbName field
   uint16_t cFieldData = 0; // number of Feat11FieldDataItems
   uint16_t entryIDL = 0; // length of entryID field
   uint16_t strFieldNameL = 0; // length of strFieldName
   uint16_t strCaptionL = 0; // length of strCaption
   uint32_t cbdxfHdrDiskL = 0; // length of cbdxfHdrDisk field
   uint32_t cbFmtInsertRowL = 0; // length of cbFmtInsertRowL
   int i = 0; // iterator for for() loop
   SFSnortPacket *sp = (SFSnortPacket *) p;

   if(sp == NULL)
      return RULE_NOMATCH;

   if(sp->payload == NULL)
      return RULE_NOMATCH;

   // flow:established, to_client;
   if (checkFlow(p, rule24666options[0]->option_u.flowFlags) <= 0 )
   return RULE_NOMATCH;

   // flowbits:isset "file.xls";
   if (processFlowbits(p, rule24666options[1]->option_u.flowBit) <= 0)
   return RULE_NOMATCH;

   if(getBuffer(sp, CONTENT_BUF_NORMALIZED, &beg_of_payload, &end_of_payload) <= 0)
   return RULE_NOMATCH;

   cursor_normal = beg_of_payload;

   // content:"x|08|", depth 0; // this is 0x7808, header for feature12
   while(contentMatch(p, rule24666options[2]->option_u.content, &cursor_normal) > 0) {
   
      cursor_detect = cursor_normal;
   
      // jump to "x|08|" offset 2, depth 2
      // there is a two byte length field and the 0x7808 header again
      cursor_detect += 2;
   
         // check if we can read two bytes
      if((cursor_detect + 2) > end_of_payload)
         return RULE_NOMATCH;
   
      // are those bytes 0x0878 (little endian)
      if((*cursor_detect != 0x78) || (*(cursor_detect+1) != 0x08))
         continue;
   
      // jump to reserved fields
      cursor_detect += 14;
   
      // Two fields labeled reserved1 and reserved2
      // total of 5 null bytes, plus 2 bytes for cref
      if((cursor_detect + 8) > end_of_payload)
         return RULE_NOMATCH;
   
      // make sure reserved fields are null
      // Normally we can't just typecase our cursor, but because we
      // are checking for NULL here, we can
      if(*((uint32_t*)cursor_detect) != 0)
         continue;
   
      // jump to cref, after reserved fields
      cursor_detect += 5;
   
      // read the cref value, we checked for 7 bytes before reserved fields
      // so we don't need to check again here
      cref = read_little_16(cursor_detect);
   
      // jump cref*8+8, this jumps over all the ref structures
      // must check for integer overflows
      cursor_tmp = cursor_detect + 16 + (cref * 8);
         
      if(cursor_tmp < cursor_detect)
            return RULE_NOMATCH;
   
      cursor_detect = cursor_tmp;
   
   
      // this jump puts us at the beginning of the rgbFeatData
      // make sure we can read crwHeader
      if((cursor_detect + 4) >= end_of_payload)
         return RULE_NOMATCH;
   
      // make sure crwHeader==0
      if(*((uint32_t*)cursor_detect) != 0)
         continue;
   
      // jump to rgbName, it is an XLUnicodeString, the first 2-bytes = length
      cursor_detect += 56;
   
      // make sure we can read rgbNameL
      if((cursor_detect + 2) > end_of_payload)
         return RULE_NOMATCH;
   
      // store rgbNameL
      rgbNameL = read_little_16(cursor_detect);
   
      // jump over rgbName
      cursor_detect += rgbNameL + 3;
   
      // make sure we can read cFieldData and entryID
      if((cursor_detect + 4) > end_of_payload)
         return RULE_NOMATCH;
   
      // store cFieldData
      cFieldData = read_little_16(cursor_detect);
   
      // jump over cFieldData
      cursor_detect += 2;
   
      // read entryIDL
      entryIDL = read_little_16(cursor_detect);
   
      // jump over entryID
      cursor_detect += 3 + entryIDL;
      
      // max 10 iterations through Feat11FieldDataItem structures
      if(cFieldData > 10) cFieldData = 10;
      
      // loop through the Feat11FieldDataItem fields
      for(i = 0; i < cFieldData; i++) {
   
         // jump to cbFmtInsertRowL
         cursor_detect += 28;
   
         // make sure we can read length of cbFmtInsertRowL and strFieldNameL
         if((cursor_detect + 16) > end_of_payload)
            return RULE_NOMATCH;
   
         // read the cbFmtInsertRowL
         cbFmtInsertRowL =  read_little_32(cursor_detect);
   
         // jump to strFieldName
         cursor_detect += 8;
   
         // read stFieldNameL
         strFieldNameL = read_little_32(cursor_detect);
   
         // jump over strFieldName, with overflow check
         cursor_tmp = cursor_detect + strFieldNameL + 3;
   
         if(cursor_tmp < cursor_detect)
            return RULE_NOMATCH;
   
         cursor_detect = cursor_tmp;
   
         // make sure we can read strCaptionL
         if((cursor_detect + 2) > end_of_payload)
            return RULE_NOMATCH;
   
         // read strCaptionL
         strCaptionL = read_little_16(cursor_detect);
   
         // jump over strCaptionL and dxFmtInsertRow
         cursor_tmp = cursor_detect + strCaptionL + cbFmtInsertRowL + 3;
   
         if(cursor_tmp < cursor_detect) 
            return RULE_NOMATCH;
   
         cursor_detect = cursor_tmp;
   
         // make sure we can read cbdxfHdrDiskL
         if((cursor_detect + 4) >  end_of_payload)
            return RULE_NOMATCH;
   
         // read the cbdxfHdrDiskL
         cbdxfHdrDiskL = read_little_32(cursor_detect);
   
         //DEBUG_SO(fprintf(stderr, "cbdxfHdrDiskL: %d\n", cbdxfHdrDiskL);)
         if(cbdxfHdrDiskL > 0x2020)
            return RULE_MATCH; // cbdxfHdrDiskL > 0x2020 is the vulnerable condition
   
         // if cbdxfHdrDiskL is <= 0x2020 than it's the length
         // used for the last field and we jump
         cursor_tmp = cursor_detect + cbdxfHdrDiskL + 4;
         if(cursor_tmp < cursor_detect)
            return RULE_NOMATCH;
   
         cursor_detect = cursor_tmp;
      }
      
      return RULE_NOMATCH;
   }
   return RULE_NOMATCH;
}
// #endif // 0 Don't compile the detection functions if they're not used
/*
Rule *rules[] = {
   &rule24666,
   NULL
};
*/
